//========================================================
// MPConvoPawn
//
// Created by Cozmo, 2011 (Recreated / fixed in 2014/2015)
//
// This mod allows you to create MP-functional missions
// and more, without having to write any code at all!
//
// See the readme for details
//
//========================================================
// note: Killer is -deliberately- the only one who is 
// directly rewarded/punished for killing the NPC in co-op
//========================================================
Class MPConvoPawn extends ScriptedPawn; //alternatively, you could extend this from your own bots

enum convType
{
	Personal,
	Cooperative
};

enum afterConv
{
	Nothing,
	Follow_Player,
	Follow_Path, //todo!
	Attack_Player
};

//----------------------------------------
// Variables!
//----------------------------------------
var() int missionNumber;
var() convType missionType;
var DeusExPlayer talkingTo;
var float talkTimer;
var int onMessage;
var MissionProgress MPA;
var bool bCoop;
var int shopping; //All interaction - not strictly shopping //0 = off, 1 = can interact, 2 = finished
var int shopState; //which Interaction[i] are we shopping from
var float followTimer;
var DeusExPlayer followPlayer;
var bool bRunTo;
var float waitTimer; //followtimer isn't needed when this is; possibly re-use that and kill this?

//----------------------------------------
// Instance defaults (for fakedeath)
//----------------------------------------
var() int respawnSeconds;
var float respawnTimer;
var name defOrders;
var vector defLocation;
var rotator defRotation;
var int defHealth;
var int defHealthArmLeft;
var int defHealthArmRight;
var int defHealthHead;
var int defHealthLegLeft;
var int defHealthLegRight;
var int defHealthTorso;

//----------------------------------------
// Appearance / Misc
//----------------------------------------
var() class<Pawn> appearAsClass;
var() string pawnName;

enum stateRange0 //enum seems unnecessary, but it's easier to understand in the editor
{
	Exactly,
	To_value2
//	Above, //this is more complicated to implement than simply using "from 1 to 99999"
//	Below  //same deal, inversely (same thing, even)
};

//----------------------------------------
// Convo structure
//----------------------------------------
struct INTERACTION //EoC = EndOfConvo //outdated thing!
{
	var() int CheckMissionState; //modified; thankfully uscript isn't case-sensitive
	var() stateRange0 CheckRange;
	var() int CheckValue2;
	var() string convoMessage[20];
	var() afterConv convo_ActionAfter;
	var() string convo_ActionPath;
	var() int convo_CreditsCost;
	var() int convo_CreditsGiven;
	var() name convo_Event;
	var() bool convo_NeedConfirmation;
	var() int convo_SetMissionState;
	var() int convo_SkillPoints;
	var() string convo_EndMessage;
	var() name death_Event;
	var() string death_Message;
	var() int death_CreditsGiven;
	var() int death_SetMissionState; //making this default = checkmissionstate would be nice for users
	var() int death_SkillPoints;
};

var() INTERACTION _Interactions[10];
var bool bBackupSys;

//----------------------------------------
// Replication
//----------------------------------------
replication 
{ 
	reliable if (Role == ROLE_Authority) 
		ConvMessage; 
}

//----------------------------------------
// Main
//----------------------------------------
function Frob(Actor Frobber, Inventory frobWith)
{
	local MissionProgress A;

	if(followPlayer != None)
	{
		//follow interaction instead, until we finish following

		if(followPlayer == DeusExPlayer(Frobber)) //move!
		{
			if(waitTimer == 0)
			{
				ConvMessage(followPlayer, pawnName$": I'll wait here.");
				followPlayer.ClientMessage("|p7"$pawnName$" will wait for two minutes max");

				waitTimer = Level.TimeSeconds + 120;
				gotoState('Standing');
				Orders='Standing';
			}
			else
			{
				followPlayer.ClientMessage("|p2"$pawnName$" is following you again");
				waitTimer = 0;
			}
		}
	}
	else if((Enemy == None) || (Health <= 0)) //if we're following, fighting or dying - don't interact
	{
		if(talkingTo == None)
		{
			foreach AllActors(class 'MissionProgress', A) //don't try to convo without a MissionProgress actor
			{
				if(A.Owner == DeusExPlayer(Frobber))
				{
					MPA=A;
					talkingTo = DeusExPlayer(Frobber); //automatically starts convo through Tick()
					
					if((Orders != 'Sitting') && (Orders != 'sitting') && (Orders != 'Standing') && (Orders != 'standing')) //case sens?
					{
						SetOrders('Standing');
						gotoState('Standing');
					}

					talkTimer = Level.TimeSeconds + 3.2;
					Converse();
				}
			}

			if(MPA == None) //if we didn't find an MPA above //interestingly, 0 lines of conversation also causes this somehow?
			{
				DeusExPlayer(Frobber).BroadcastMessage("|p2ERROR: ESSENTIAL ACTOR or DIALOGUE not found. Please inform the mapper!");
			}
		}
		else
		{
			if(DeusExPlayer(Frobber) != talkingTo)
			{
				DeusExPlayer(Frobber).ClientMessage("|p2"$pawnName$" is already talking to "$talkingTo.PlayerReplicationInfo.PlayerName);
			}
			else //no busyMsg for talkee. Also, interactions!
			{
				if(shopping != 0)
				{
					if(_Interactions[shopState].convo_CreditsCost > 0)
					{
						if(DeusExPlayer(Frobber).Credits >= _Interactions[shopState].convo_CreditsCost)
						{
							DeusExPlayer(Frobber).ClientMessage("|p1"$_Interactions[shopState].convo_CreditsCost$" credits spent");
							DeusExPlayer(Frobber).Credits -= _Interactions[shopState].convo_CreditsCost;
							FinishConvo(shopState, DeusExPlayer(Frobber));
						}
						else
						{
							DeusExPlayer(Frobber).ClientMessage("|p2You don't have "$_Interactions[shopState].convo_CreditsCost$" credits!");
						}
					}
					else
					{
						//if not buying, must be confirmation
						
						DeusExPlayer(Frobber).ClientMessage(" ");
						FinishConvo(shopState, DeusExPlayer(Frobber));
					}
				}
			}
		}
	}
}

function Tick(float deltaTime)
{
	if(talkingTo != None)
	{
		LookAtActor(talkingTo, true, true, true, 0, 0.5);
		LipSynch(deltaTime); //gesture randomly. Possibly remove?

		if(talkTimer <= Level.TimeSeconds)
		{
			talkTimer = Level.TimeSeconds + 3.2; //time per convo line - experiment with this value
			Converse();
		}

	}

	if(waitTimer != 0)
	{
		if(waitTimer <= Level.TimeSeconds)
		{
			if(followPlayer != none)
			{
				followPlayer.ClientMessage("|p2You have abandoned your follower, "$pawnName);
				followPlayer = none;
			}

			waitTimer = 0;
		}
	}

	if(followPlayer != None)
	{
		if(followTimer <= Level.TimeSeconds)
		{
			followTimer = Level.TimeSeconds + 1; //update directions once a second. Decrease?
			doFollow();
		}

		if(followPlayer.Health <= 0) //if player dies, stop following IMMEDIATELY or they can respawn with enough health to continue
		{
			followPlayer = None;
			waitTimer = 0;
		}
	}

	if(bHidden == true)
	{
		if(respawnTimer <= Level.TimeSeconds)
		{
			bHidden = false;
			defOrders = Orders;

			Health = defHealth;
			HealthArmLeft = defHealthArmLeft;
			HealthArmRight = defHealthArmRight;
			HealthHead = defHealthHead;
			HealthLegLeft = defHealthLegLeft;
			HealthLegRight = defHealthLegRight;
			HealthTorso = defHealthTorso;

			bDistressed = false;

			EnterWorld();

			SetLocation(defLocation);
			SetRotation(defRotation);
		}
	}

	Super.Tick(deltaTime);
}

function Converse()
{
	local int i;

	if(talkingTo == None) //Did the player leave the game?
	{
		LeaveConvo();
		return;
	}
	else
	{
		if(talkingTo.Health <= 0) //If not, are they still alive?
		{
			LeaveConvo();
			return;
		}

		if(VSize(Location-talkingTo.Location) > 300) //Did they wander off?
		{
			talkingTo.ClientMessage("|p2You walked away too early!");
			LeaveConvo();
			return;
		}
	}

	//Okay good. Now for the convo stuff:

	for(i=0; i<10; i++)
	{
		switch (_Interactions[i].checkRange) //I used to think you HAD to use a switch for enum!
		{
			case Exactly:

			if(_Interactions[i].checkMissionState == MPA.GetMissionState(missionNumber, bCoop))
			{
				if(_Interactions[i].convoMessage[onMessage] != "") //no onMessage+1 here because of single line convos
				{
					ConvMessage(talkingTo, _Interactions[i].convoMessage[onMessage]);
					OnMessage++;

					////was that the last line? then let's end the convo so the player can walk away here
					//if(_Interactions[i].convoMessage[onMessage+1] == "") //doesn't work? Strange...
					//{
					//	FinishConvo(i, talkingTo);
					//}

					return;
				}
				else
				{
					if(_Interactions[i].convo_CreditsCost > 0) //"shopping"
					{
						if(shopping >= 2) //shouldn't ever go above 2, but just in case...
						{
							talkingTo.ClientMessage("|p2Transaction cancelled");
							LeaveConvo();
						}
						else
						{
							shopping++;

							if(shopping == 1)
							{
								shopState = i;
								talkingTo.ClientMessage("|p7("$pawnName$" wants "$_Interactions[i].convo_CreditsCost$" credits. Right click again to confirm)");
								return;
							}
						}
					}
					else //8
					{	
						if(_Interactions[i].convo_NeedConfirmation == true)
						{
							if(shopping >= 2) //shouldn't ever go above 2, but just in case...
							{
								talkingTo.ClientMessage("|p2You didn't accept");
								LeaveConvo();
							}
							else
							{
								shopping++;

								if(shopping == 1)
								{
									shopState = i;
									talkingTo.ClientMessage("|p7(Right click again to confirm)");
									return;
								}
							}
						}
						else
						{
							FinishConvo(i, talkingTo);
						}
					}
				}

				return; //new //SUCCESS
			}

			break;

			case To_value2:

			//is the mission state bigger/equal to value 1, AND smaller/equal to value 2?
			if((_Interactions[i].checkMissionState <= MPA.GetMissionState(missionNumber, bCoop)) && (_Interactions[i].checkValue2 >= MPA.GetMissionState(missionNumber, bCoop)))
			{
				if(_Interactions[i].convoMessage[onMessage] != "") //no onMessage+1 here because of single line convos
				{
					ConvMessage(talkingTo, _Interactions[i].convoMessage[onMessage]);
					OnMessage++;

					return;
				}
				else
				{
					if(_Interactions[i].convo_CreditsCost > 0) //"shopping"
					{
						if(shopping >= 2) //shouldn't ever go above 2, but just in case...
						{
							talkingTo.ClientMessage("|p2Transaction cancelled");
							LeaveConvo();
						}
						else
						{
							shopping++;

							if(shopping == 1)
							{
								shopState = i;
								talkingTo.ClientMessage("|p7("$pawnName$" wants "$_Interactions[i].convo_CreditsCost$" credits. Right click again to confirm)");
								return;
							}
						}
					}
					else //8
					{	
						if(_Interactions[i].convo_NeedConfirmation == true)
						{
							if(shopping >= 2) //shouldn't ever go above 2, but just in case...
							{
								talkingTo.ClientMessage("|p2You didn't accept");
								LeaveConvo();
							}
							else
							{
								shopping++;

								if(shopping == 1)
								{
									shopState = i;
									talkingTo.ClientMessage("|p7(Right click again to confirm)");
									return;
								}
							}
						}
						else
						{
							FinishConvo(i, talkingTo);
						}
					}
				}

				return;
			}
				
			break;
		}
	}
}

function LeaveConvo()
{
	//BroadcastMessage("DEBUG: L");

	onMessage = 0;
	talkingTo = None;
	MPA = None;
	shopping = 0;
	shopState = 0;

	if((Enemy == None) && (Orders != defOrders)) //if we're not fighting and we're doing something else:
	{
		SetOrders(defOrders);
		gotoState(defOrders);
	}
}

function FinishConvo(int i, DeusExPlayer P)
{
	local Actor A;
	local DeusExPlayer dxp;
	local bool mover;

	MPA.SetMissionState(missionNumber,_Interactions[i].convo_SetMissionState, bCoop);

	if(_Interactions[i].convo_ActionAfter == Follow_Player)
	{
		followPlayer = P;
	}
	else if(_Interactions[i].convo_ActionAfter == Attack_Player)
	{
		//SetEnemy(P, 0, true);
		gotoState('Attacking');
		Enemy = P;
        	//bAttacking = True;
        	//SetDistress(true);
		//TakeDamage(1, Enemy, Location, vect(0,0,0), 'shot');

		//none of this works I HATE YOU SCRIPTEDPAWN

		//...okay, so I need to actually change our Player alliance to -1. todo.
	}

	if(missionType == Cooperative) //reward everyone we can see
	{
		foreach VisibleActors(class'DeusExPlayer', dxp, 800, Location)
		{
			if(_Interactions[i].convo_CreditsGiven > 0)
			{
				dxp.Credits += _Interactions[i].convo_CreditsGiven;
				dxp.ClientMessage("|p7"$_Interactions[i].convo_CreditsGiven$" credits received");
			}
			else if(_Interactions[i].convo_CreditsGiven < 0) //don't print a message for 0 credits
			{
				dxp.Credits += _Interactions[i].convo_CreditsGiven;
				dxp.ClientMessage("|p2"$_Interactions[i].convo_CreditsGiven$" CREDITS LOST");

				if(dxp.Credits < 0)
				{
					dxp.Credits = 0;
				}
			}

			if(_Interactions[i].convo_SkillPoints > 0)
			{
				dxp.SkillPointsAdd(_Interactions[i].convo_SkillPoints);
			}

			if(_Interactions[i].convo_Event != '')
			{
				foreach AllActors(class 'Actor', A, _Interactions[i].convo_Event)
				{
					if(A.IsA('DeusExMover'))
					{
						if(mover == false) //only trigger movers ONCE! Opening and then closing a door is useless!
						{		   //we DO still want to trigger other stuff though, so we have to do this
							mover = true;
							A.Trigger(Self,dxp);
						}
					}
					else
					{
						A.Trigger(Self,dxp);
					}
				}
			}

			if(_Interactions[i].convo_EndMessage != "")
			{
				dxp.ClientMessage(_Interactions[i].convo_EndMessage);
			}
		}
	}
	else
	{
		if(_Interactions[i].convo_CreditsGiven > 0)
		{
			P.Credits += _Interactions[i].convo_CreditsGiven;
			P.ClientMessage("|p7"$_Interactions[i].convo_CreditsGiven$" credits received");
		}
		else if(_Interactions[i].convo_CreditsGiven < 0) //don't print a message for 0 credits
		{
			P.Credits += _Interactions[i].convo_CreditsGiven;
			P.ClientMessage("|p2"$_Interactions[i].convo_CreditsGiven$" CREDITS LOST");

			if(P.Credits < 0)
			{
				P.Credits = 0;
			}
		}

		if(_Interactions[i].convo_SkillPoints > 0)
		{
			P.SkillPointsAdd(_Interactions[i].convo_SkillPoints);
		}

		if(_Interactions[i].convo_Event != '')
		{
			foreach AllActors(class 'Actor', A, _Interactions[i].convo_Event)
			{
				A.Trigger(Self,P);
			}
		}

		if(_Interactions[i].convo_EndMessage != "")
		{
			P.ClientMessage(_Interactions[i].convo_EndMessage);
		}
	}

	LeaveConvo(); //then we finish it up
}

function BeginPlay()
{
	if(missionType == Cooperative)
	{
		bCoop = true;
	}

	if(appearAsClass != None) //todo: add groundspeed! baseassheight etc
	{
		Mesh=appearAsClass.default.Mesh;
		SetCollisionSize(appearAsClass.default.CollisionRadius,appearAsClass.default.CollisionHeight);
		BaseEyeHeight=appearAsClass.default.BaseEyeHeight;
		AmbientSound=appearAsClass.default.AmbientSound;
		SoundRadius=appearAsClass.default.SoundRadius;
		SoundVolume=appearAsClass.default.SoundVolume;
		bIsFemale=appearAsClass.default.bIsFemale;
		MultiSkins[0]=appearAsClass.default.MultiSkins[0];
		MultiSkins[1]=appearAsClass.default.MultiSkins[1];
		MultiSkins[2]=appearAsClass.default.MultiSkins[2];
		MultiSkins[3]=appearAsClass.default.MultiSkins[3];
		MultiSkins[4]=appearAsClass.default.MultiSkins[4];
		MultiSkins[5]=appearAsClass.default.MultiSkins[5];
		MultiSkins[6]=appearAsClass.default.MultiSkins[6];
		MultiSkins[7]=appearAsClass.default.MultiSkins[7];
		Texture=appearAsClass.default.Texture;
		drawScale=appearAsClass.default.drawScale;
		UnfamiliarName=appearAsClass.default.UnfamiliarName; //TODO: check if familiar instead (for mp)?
	}

	if (bIsFemale)
	{
		HitSound1 = Sound'FemalePainMedium';
		HitSound2 = Sound'FemalePainLarge';
		Die = Sound'FemaleDeath';
	}

	if(pawnName != "|p2Default Pawn Name (Report as a bug)")
	{
		UnfamiliarName=pawnName; //I -think- this one is used in MP
		//FamiliarName=pawnName;
		//BindName=pawnName;
	}

	defOrders = Orders;
	defLocation = Location;
	defRotation = Rotation;
	defHealth = Health;
	defHealthArmLeft = HealthArmLeft;
	defHealthArmRight = HealthArmRight;
	defHealthHead = HealthHead;
	defHealthLegLeft = HealthLegLeft;
	defHealthLegRight = HealthLegRight;
	defHealthTorso = HealthTorso;

	Super.BeginPlay();
}

function WhenKilled(pawn Killer) //todo: call this through a fakeDeath() state (don't ever destroy the pawn, just hide them and 'respawn' later). using SpawnCarcass() for now.
{
	local DeusExPlayer P;
	local int i;
	local Actor A;
	local MissionProgress B;

	LeaveConvo();

	bHidden = true;
	LeaveWorld(); //experimental
	respawnTimer = Level.TimeSeconds += respawnSeconds;

	if(Killer.IsA('DeusExPlayer'))
	{
		P = DeusExPlayer(Killer);

		if(followPlayer != None)
		{
			followPlayer.ClientMessage("|p2One of your followers, "$pawnName$", has been killed.");
		}

		foreach AllActors(class 'MissionProgress', B)
		{
			if(B.Owner == Killer)
			{
				MPA=B;

				for (i=0; i<10; i++)
				{
					switch (_Interactions[i].checkRange) //I can't make these look nice ever. ESPECIALLY HERE
					{
						case Exactly:

						if(_Interactions[i].checkMissionState == MPA.GetMissionState(missionNumber, bCoop))
						{
							MPA.SetMissionState(missionNumber,_Interactions[i].death_SetMissionState, bCoop);

							if(_Interactions[i].death_CreditsGiven > 0)
							{
								DeusExPlayer(Killer).Credits += _Interactions[i].death_CreditsGiven;
								DeusExPlayer(Killer).ClientMessage("|p7"$_Interactions[i].death_CreditsGiven$" credits received");
							}
							else if(_Interactions[i].death_CreditsGiven < 0) //don't print a message for 0 credits
							{
								DeusExPlayer(Killer).Credits += _Interactions[i].death_CreditsGiven;
								DeusExPlayer(Killer).ClientMessage("|p2"$_Interactions[i].death_CreditsGiven$" CREDITS LOST");

								if(DeusExPlayer(Killer).Credits < 0)
								{
									DeusExPlayer(Killer).Credits = 0;
								}
							}

							if(_Interactions[i].death_SkillPoints > 0)
							{
								DeusExPlayer(Killer).SkillPointsAdd(_Interactions[i].death_SkillPoints);
							}

							if(_Interactions[i].death_Event != '')
							{
								foreach AllActors(class 'Actor', A, _Interactions[i].death_Event)
								{
									A.Trigger(Self,P);
								}
							}

							if(_Interactions[i].death_Message != "")
							{
								P.ClientMessage(_Interactions[i].death_Message);
							}
						}

						break;

						case To_value2:

						//is the mission state bigger/equal to value 1, AND smaller/equal to value 2?
						if((_Interactions[i].checkMissionState <= MPA.GetMissionState(missionNumber, bCoop)) && (_Interactions[i].checkValue2 >= MPA.GetMissionState(missionNumber, bCoop)))
						{
							MPA.SetMissionState(missionNumber,_Interactions[i].death_SetMissionState, bCoop);

							if(_Interactions[i].death_CreditsGiven > 0)
							{
								DeusExPlayer(Killer).Credits += _Interactions[i].death_CreditsGiven;
								DeusExPlayer(Killer).ClientMessage("|p7"$_Interactions[i].death_CreditsGiven$" credits received");
							}
							else if(_Interactions[i].death_CreditsGiven < 0) //don't print a message for 0 credits
							{
								DeusExPlayer(Killer).Credits += _Interactions[i].death_CreditsGiven;
								DeusExPlayer(Killer).ClientMessage("|p2"$_Interactions[i].death_CreditsGiven$" CREDITS LOST");

								if(DeusExPlayer(Killer).Credits < 0)
								{
									DeusExPlayer(Killer).Credits = 0;
								}
							}

							if(_Interactions[i].death_SkillPoints > 0)
							{
								DeusExPlayer(Killer).SkillPointsAdd(_Interactions[i].death_SkillPoints);
							}

							if(_Interactions[i].death_Event != '')
							{
								foreach AllActors(class 'Actor', A, _Interactions[i].death_Event)
								{
									A.Trigger(Self,P);
								}
							}

							if(_Interactions[i].death_Message != "")
							{
								P.ClientMessage(_Interactions[i].death_Message);
							}
						}

						break;
					}
				}
			}
		}

		//No MPA found = do nothing. Add error msg here if it's ever required
	}
}

function Carcass SpawnCarcass() //TEMPORARY FUNCTION. REPLACE LATER! (todo:)
{
	WhenKilled(Enemy);		

	return Super.SpawnCarcass();
}

// ----------------------------------------------------------------------
// TakeDamageBase()
//
// Modified from DeusEx.ScriptedPawn.uc
// ----------------------------------------------------------------------
function TakeDamageBase(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType,
                        bool bPlayAnim)
{
	local int          actualDamage;
	local Vector       offset;
	local float        origHealth;
	local EHitLocation hitPos;
	local float        shieldMult;

	// use the hitlocation to determine where the pawn is hit
	// transform the worldspace hitlocation into objectspace
	// in objectspace, remember X is front to back
	// Y is side to side, and Z is top to bottom
	offset = (hitLocation - Location) << Rotation;

	if (!CanShowPain())
		bPlayAnim = false;

	// Prevent injury if the NPC is intangible
	if (!bBlockActors && !bBlockPlayers && !bCollideActors)
		return;

	// No damage + no damage type = no reaction
	if ((Damage <= 0) && (damageType == 'None'))
		return;

	// Block certain damage types; perform special ops on others
	if (!FilterDamageType(instigatedBy, hitLocation, offset, damageType))
		return;

	// Impart momentum
	ImpartMomentum(momentum, instigatedBy);

	actualDamage = ModifyDamage(Damage, instigatedBy, hitLocation, offset, damageType);

	if (actualDamage > 0)
	{
		shieldMult = ShieldDamage(damageType);
		if (shieldMult > 0)
			actualDamage = Max(int(actualDamage*shieldMult), 1);
		else
			actualDamage = 0;
		if (shieldMult < 1.0)
			DrawShield();
	}

	origHealth = Health;

	hitPos = HandleDamage(actualDamage, hitLocation, offset, damageType);
	if (!bPlayAnim || (actualDamage <= 0))
		hitPos = HITLOC_None;

	if (bCanBleed)
		if ((damageType != 'Stunned') && (damageType != 'TearGas') && (damageType != 'HalonGas') &&
		    (damageType != 'PoisonGas') && (damageType != 'Radiation') && (damageType != 'EMP') &&
		    (damageType != 'NanoVirus') && (damageType != 'Drowned') && (damageType != 'KnockedOut') &&
		    (damageType != 'Poison') && (damageType != 'PoisonEffect'))
			bleedRate += (origHealth-Health)/(0.3*Default.Health);  // 1/3 of default health = bleed profusely

	if (CarriedDecoration != None)
		DropDecoration();

	if ((actualDamage > 0) && (damageType == 'Poison'))
		StartPoison(Damage, instigatedBy);

	if (Health <= 0)
	{
		broadcastmessage("|p2KIND OF DEAD. DEBUG!");

		// gib us if we get blown up
		//if (DamageType == 'Exploded')
		//	Health = -10000;
		//else
		//	Health = -1;

		WhenKilled(instigatedBy); //FAKEDEATH! put in state later, for better anim etc

		return;
	}

	// play a hit sound
	if (DamageType != 'Stunned')
		PlayTakeHitSound(actualDamage, damageType, 1);

	if ((DamageType == 'Flamed') && !bOnFire)
		CatchFire();

	ReactToInjury(instigatedBy, damageType, hitPos);
}

//----------------------------------------
// Made by Alex (MMShowMessage) and shared
// in the dxalpha Scripting Society
//
// Slightly modified for multiple players
//----------------------------------------
simulated function ConvMessage(DeusExPlayer P, string Message)
{
	local HUDMissionStartTextDisplay _HUD;
	local DeusExPlayer dxp;

	if(missionType == Cooperative) //talk to everyone we can see
	{
		foreach VisibleActors(class'DeusExPlayer', dxp, 800, Location) //previously had P.location
		{
			if(bBackupSys != true)
			{
				if((dxp.RootWindow != None) && (DeusExRootWindow(dxp.RootWindow).HUD != None))
				{
					_HUD = DeusExRootWindow(dxp.RootWindow).HUD.startDisplay;
				}

				if(_HUD != None) 
				{ 
					_HUD.shadowDist = 0; 
					_HUD.Message = ""; 
					_HUD.charIndex = 0; 
					_HUD.winText.SetText(""); 
					_HUD.winTextShadow.SetText(""); 
					_HUD.displayTime = 5.50; 
					_HUD.perCharDelay = 0.30; 
					_HUD.AddMessage(Message); 
					_HUD.StartMessage(); 
				}
			}
			else
			{
				dxp.ClientMessage(Message);
			}
		}
	}
	else //just one.
	{
		if(bBackupSys != true)
		{
			if((P.RootWindow != None) && (DeusExRootWindow(P.RootWindow).HUD != None))
			{
				_HUD = DeusExRootWindow(P.RootWindow).HUD.startDisplay;
			}

			if(_HUD != None) 
			{ 
				_HUD.shadowDist = 0; 
				_HUD.Message = ""; 
				_HUD.charIndex = 0; 
				_HUD.winText.SetText(""); 
				_HUD.winTextShadow.SetText(""); 
				_HUD.displayTime = 5.50; 
				_HUD.perCharDelay = 0.30; 
				_HUD.AddMessage(Message); 
				_HUD.StartMessage(); 
			}
		}
		else
		{
			dxp.ClientMessage(Message);
		}
	}
}

State Follow
{
	function SetFall()
	{
		StartFalling('Patrolling', 'ContinuePatrol');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
		CheckOpenDoor(HitNormal, Wall);
	}
	
	function AnimEnd()
	{
		PlayWaiting();
	}

	function BeginState()
	{
		StandUp();
		//SetEnemy(None, EnemyLastSeen, true);
		Disable('AnimEnd');
		//SetupWeapon(false);
		//SetDistress(false);
		SeekPawn = None;
		//EnableCheckDestLoc(false);
	}

	function EndState()
	{
		//EnableCheckDestLoc(false);
		Enable('AnimEnd');
		//bStasis = true;
	}

	Begin:

	if(followPlayer != none)
	{
		if(bRunTo == False)
		{
			PlayWalking();
			MoveToward(followPlayer , 0.120000);
		}
		else
		{
			PlayRunning();
			MoveToward(followPlayer , 180.000000);
		}

	}
}

function doFollow()
{
	local vector loc;

	if((followPlayer != None) && (Enemy == None) && (waitTimer == 0))
	{
		if(VSize(Location-followPlayer.Location) > 1200)
		{
			loc = followPlayer.Location;
			loc -= 32.0 * followPlayer.CollisionRadius * vector(followPlayer.ViewRotation);
			loc.Z += followPlayer.CollisionHeight * 0.9;

			SetLocation(loc);
		}
		else if(VSize(Location-followPlayer.Location) < 200)
		{
			gotoState('Standing');
		}
		else
		{
			GetMoving();
		}
	}
}

function GetMoving()
{
	if(followPlayer != None)
	{
		if(VSize(Location-followPlayer.Location) > 300)
		{
			bRunTo = True;
			gotoState('Follow');
		}
		else if(VSize(Location-followPlayer.Location) > 200)
		{
			bRunTo = False;
			gotoState('Follow');
		}
		else
		{
			gotoState('Standing');
		}
	}
}

defaultproperties
{
     respawnSeconds=5
     shopping=0
     pawnName="|p2Default Pawn Name (Report as a bug)"
     bCoop=false
     bInvincible=False
     DrawType=DT_Mesh
     Mesh=LodMesh'DeusExCharacters.GM_DressShirt'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     Texture=Texture'DeusExDeco.Skins.AlarmLightTex5'
     MultiSkins(0)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(1)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(2)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.PantsTex5'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.Male3Tex1'
     MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     _Interactions(0)=(convo_SetMissionState=-999) //messy, but less problematic for users than leaving it as 0
     _Interactions(1)=(convo_SetMissionState=-999)
     _Interactions(2)=(convo_SetMissionState=-999)
     _Interactions(3)=(convo_SetMissionState=-999)
     _Interactions(4)=(convo_SetMissionState=-999)
     _Interactions(5)=(convo_SetMissionState=-999)
     _Interactions(6)=(convo_SetMissionState=-999)
     _Interactions(7)=(convo_SetMissionState=-999)
     _Interactions(8)=(convo_SetMissionState=-999)
     _Interactions(9)=(convo_SetMissionState=-999)
     _Interactions(0)=(death_SetMissionState=-999)
     _Interactions(1)=(death_SetMissionState=-999)
     _Interactions(2)=(death_SetMissionState=-999)
     _Interactions(3)=(death_SetMissionState=-999)
     _Interactions(4)=(death_SetMissionState=-999)
     _Interactions(5)=(death_SetMissionState=-999)
     _Interactions(6)=(death_SetMissionState=-999)
     _Interactions(7)=(death_SetMissionState=-999)
     _Interactions(8)=(death_SetMissionState=-999)
     _Interactions(9)=(death_SetMissionState=-999)
     bKeepWeaponDrawn=True
     BaseAccuracy=0.200000
     maxRange=1000.000000
     MinHealth=20.000000
     bPlayIdle=True
     bAimForHead=True
     bCanCrouch=True
     bSprint=True
     CrouchRate=1.000000
     SprintRate=1.000000
     bReactAlarm=True
     RaiseAlarm=RAISEALARM_Never
     EnemyTimeout=5.000000
     bCanTurnHead=True
     WaterSpeed=80.000000
     AirSpeed=160.000000
     AccelRate=500.000000
     BaseEyeHeight=40.000000
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     HitSound1=Sound'DeusExSounds.Player.MalePainSmall'
     HitSound2=Sound'DeusExSounds.Player.MalePainMedium'
     Die=Sound'DeusExSounds.Player.MaleDeath'
     NameArticle=""
     VisibilityThreshold=0.010000
     DrawType=DT_Mesh
     Mass=150.000000
     Buoyancy=155.000000
     BindName="NPC"
     unfamiliarname="Stranger"
     bHateInjury=True
     bHateShot=False
     bHateDistress=False
     bHateCarcass=False
     bHateWeapon=False
}